/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.config;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record GolemMaterial(HashMap<GolemStatType, Double> stats, HashMap<GolemModifier, Integer> modifiers, ResourceLocation id, Item part) {
    public static final ResourceLocation EMPTY = new ResourceLocation("modulargolems", "empty");

    public static Map<Attribute, Pair<GolemStatType, Double>> collectAttributes(List<GolemMaterial> list, List<UpgradeItem> upgrades) {
        LinkedHashMap<Attribute, Map<GolemStatType, Double>> values = new LinkedHashMap<Attribute, Map<GolemStatType, Double>>();
        for (GolemStatType golemStatType : GolemTypes.STAT_TYPES.get().getValues()) {
            GolemMaterial.appendStat(values, golemStatType, 0.0);
        }
        for (GolemMaterial golemMaterial : list) {
            golemMaterial.stats.forEach((k, v) -> GolemMaterial.appendStat(values, k, v));
        }
        for (Map.Entry entry : GolemMaterial.collectModifiers(list, upgrades).entrySet()) {
            Object k2 = entry.getKey();
            if (!(k2 instanceof AttributeGolemModifier)) continue;
            AttributeGolemModifier attr = (AttributeGolemModifier)((Object)k2);
            for (AttributeGolemModifier.AttrEntry attrEntry : attr.entries) {
                GolemMaterial.appendStat(values, attrEntry.type().get(), attrEntry.getValue((Integer)entry.getValue()));
            }
        }
        LinkedHashMap<Attribute, Pair<GolemStatType, Double>> ans = new LinkedHashMap<Attribute, Pair<GolemStatType, Double>>();
        for (Map.Entry ent : ((HashMap)values).entrySet()) {
            LinkedHashMap<GolemStatType.Kind, Pair> linkedHashMap = new LinkedHashMap<GolemStatType.Kind, Pair>();
            for (Map.Entry entry : ((Map)ent.getValue()).entrySet()) {
                linkedHashMap.compute(((GolemStatType)((Object)entry.getKey())).kind, (k, old) -> Pair.of((Object)((Object)((GolemStatType)((Object)((Object)((Object)entry.getKey()))))), (Object)((old == null ? 0.0 : (Double)old.getSecond()) + (Double)entry.getValue())));
            }
            if (linkedHashMap.isEmpty()) continue;
            if (linkedHashMap.size() == 1) {
                ans.put((Attribute)ent.getKey(), (Pair<GolemStatType, Double>)((Pair)((HashMap)linkedHashMap).values().stream().findFirst().get()));
                continue;
            }
            if (!linkedHashMap.containsKey((Object)GolemStatType.Kind.BASE)) {
                throw new IllegalStateException("Only attributes with BASE modification allows multi-operation. Attribute: " + ((Attribute)ent.getKey()).m_22087_());
            }
            Pair candidate = (Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.BASE);
            GolemStatType type = (GolemStatType)((Object)candidate.getFirst());
            double d = (Double)candidate.getSecond();
            if (linkedHashMap.containsKey((Object)GolemStatType.Kind.ADD)) {
                d += ((Double)((Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.ADD)).getSecond()).doubleValue();
            }
            if (linkedHashMap.containsKey((Object)GolemStatType.Kind.PERCENT)) {
                d *= 1.0 + (Double)((Pair)((HashMap)linkedHashMap).get((Object)GolemStatType.Kind.PERCENT)).getSecond();
            }
            ans.put((Attribute)ent.getKey(), (Pair<GolemStatType, Double>)Pair.of((Object)((Object)type), (Object)d));
        }
        return ans;
    }

    private static void appendStat(Map<Attribute, Map<GolemStatType, Double>> values, GolemStatType k, double v) {
        values.computeIfAbsent(k.getAttribute(), e -> new LinkedHashMap()).compute(k, (e, old) -> (old == null ? 0.0 : old) + v);
    }

    public static HashMap<GolemModifier, Integer> collectModifiers(Collection<GolemMaterial> list, Collection<UpgradeItem> upgrades) {
        LinkedHashMap<GolemModifier, Integer> values = new LinkedHashMap<GolemModifier, Integer>();
        for (GolemMaterial stats : list) {
            stats.modifiers.forEach((k, v) -> values.compute((GolemModifier)((Object)k), (a, old) -> Math.min(a.maxLevel, (old == null ? 0 : old) + v)));
        }
        upgrades.stream().flatMap(e -> e.get().stream()).forEach(e -> values.compute(e.mod(), (a, old) -> Math.min(a.maxLevel, (old == null ? 0 : old) + e.level())));
        return values;
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void addAttributes(List<GolemMaterial> list, List<UpgradeItem> upgrades, T entity) {
        AttributeSupplier map = DefaultAttributes.m_22297_((EntityType)((EntityType)Wrappers.cast(entity.m_6095_())));
        Map<Attribute, Pair<GolemStatType, Double>> attrs = GolemMaterial.collectAttributes(list, upgrades);
        attrs.keySet().forEach(e -> {
            AttributeInstance attr = entity.m_21051_((Attribute)e);
            if (attr != null) {
                attr.m_22100_(map.m_22253_(e));
            }
        });
        attrs.forEach((k, v) -> ((GolemStatType)((Object)((Object)v.getFirst()))).applyToEntity((LivingEntity)entity, (Double)v.getSecond()));
    }

    public static Optional<ResourceLocation> getMaterial(ItemStack stack) {
        for (Map.Entry<ResourceLocation, Ingredient> ent : GolemMaterialConfig.get().ingredients.entrySet()) {
            if (!ent.getValue().test(stack)) continue;
            return Optional.of(ent.getKey());
        }
        return Optional.empty();
    }

    public MutableComponent getDesc() {
        return Component.m_237115_((String)("golem_material." + this.id.m_135827_() + "." + this.id.m_135815_())).m_130940_(ChatFormatting.GOLD);
    }

    public GolemPart<?, ?> getPart() {
        return (GolemPart)Wrappers.cast((Object)this.part());
    }
}

